﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VIRP.CRS.BLL;
using VIRP_WEB.BaseCode;
using VIRP_WEB.Custom.EFR;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class ReportParametersControl : UserControl
    {
        List<ReportParameter> reportParameters = new List<ReportParameter>();
        private UserSession userSession;

        protected UserSession UserSession
        {
            get
            {
                if (Session["UserSession"] != null)
                {
                    userSession = (UserSession)Session["UserSession"];
                }

                if (userSession == null) userSession = new UserSession();

                return userSession;
            }
            set
            {
                userSession = value;
            }
        }

        public string ServerReportName { get; set; }
        public string ServerReportParameters { get; set; }
        public bool YearsSelection { get; set; }

        private bool yearsDefinition = true;
        public bool YearsDefinition
        {
            get { return yearsDefinition; }
            set { yearsDefinition = value; }
        }

        private bool visnsSelection = true;
        public bool VisnsSelection
        {
            get { return visnsSelection; }
            set { visnsSelection = value; }
        }

        private bool referralId = false;
        public bool ShowReferralId
        {
            get { return referralId; }
            set { referralId = value; }
        }

        private bool username = false;
        public bool UserNameFilter
        {
            get { return username; }
            set { username = value; }
        }

        private bool dateFrom = false;
        public bool DateFrom
        {
            get { return dateFrom; }
            set { dateFrom = value; }
        }

        private bool dateTo = false;
        public bool DateTo
        {
            get { return dateTo; }
            set { dateTo = value; }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                //visns
                if (VisnsSelection)
                {
                    GetVisnsListBox();
                }
                else
                {
                    ListBoxVisns.Visible = false;
                    LabelVisn.Visible = false;
                    CellForListBoxVisns.Visible = false;
                }

                //Years Selection
                if (YearsSelection)
                {
                    GetYearsListBox();
                }
                else
                {
                    ListBoxYearSelection.Visible = false;
                    LabelYearSelection.Visible = false;
                    CellForListBoxYearSelection.Visible = false;
                }

                //Years Definition
                if (!YearsDefinition)
                {
                    DropDownListYearDefinition.Visible = false;
                    LabelYearDefinition.Visible = false;
                    RequiredFieldValidatorDropDownListYearDefinition.Enabled = false;

                    CellForDropDownListYearDefinition.Visible = false;
                }

                //Referral Id
                if (!ShowReferralId)
                {
                    TextBoxReferralId.Visible = false;
                    LabelReferralId.Visible = false;
                    RangeValidatorTextBoxReferralId.Enabled = false;

                    CellForTextBoxReferralId.Visible = false;
                }

                //Date From
                if (!DateFrom)
                {
                    TextBoxDateFrom.Visible = false;
                    LabelDateFrom.Visible = false;
                    CompareValidatorTextBoxDateFrom.Enabled = false;

                    CellForTextBoxDateFrom.Visible = false;
                }
                else
                {
                    CompareValidatorTextBoxDateFrom.ValueToCompare = DateTime.Now.ToShortDateString();
                }

                //Date To
                if (!DateTo)
                {
                    TextBoxDateTo.Visible = false;
                    LabelDateTo.Visible = false;
                    CompareValidatorTextBoxDateTo.Enabled = false;

                    CellForTextBoxDateTo.Visible = false;
                }
                else
                {
                    CompareValidatorTextBoxDateTo.ValueToCompare = DateTime.Now.ToShortDateString();
                }

                //Username
                if (!UserNameFilter)
                {
                    TextBoxUserName.Visible = false;
                    LabelForTextBoxUserName.Visible = false;
                    RequiredFieldValidatorUserName.Enabled = false;

                    CellForTextBoxUserName.Visible = false;
                }
            }
        }
        protected void ButtonRunReportClick(object sender, EventArgs e)
        {
            ReportViewerReport.Reset();
            SetReportPath();
            SetReportParameters();

            ReportViewerReport.ProcessingMode = ProcessingMode.Remote;
            ReportViewerReport.Visible = true;
            ReportViewerReport.ServerReport.Refresh();
        }

        private void SetReportPath()
        {
            const string BaseReportPath = "/EFR/";

            ReportViewerReport.ServerReport.ReportPath = ServerReportName;

            var userName = HttpContext.Current.User.Identity.Name;
            var registryId = GetCurrentRegistryId();

            var reportServerUrlSetting = SETTINGSManager.GetItemByRegistryName(userName, registryId, "ReportServerUrl");
            ReportViewerReport.ServerReport.ReportServerUrl = new Uri(reportServerUrlSetting.VALUE);

            if (ReportViewerReport.ServerReport.ReportPath.IndexOf(BaseReportPath, 0) == -1)
                ReportViewerReport.ServerReport.ReportPath = BaseReportPath + ReportViewerReport.ServerReport.ReportPath;
        }

        private int GetCurrentRegistryId()
        {
            Control baseControl = Parent;
            EfrBasePage basePage = baseControl.Page as EfrBasePage;
            if (basePage != null)
                return basePage.CurrentRegistryId;

            return default(int);
        }

        private void SetReportParameters()
        {
            reportParameters.Clear();

            SetUsername();
            SetUsernameFilter();
            SetReferralId();
            SetDateFrom();
            SetDateTo();
            SetVisns();
            SetYearsDefinition();
            SetYears();

            ReportViewerReport.ServerReport.SetParameters(reportParameters);
        }
        private void SetDateTo()
        {
            if (DateTo && TextBoxDateTo.Text != "")
            {
                ReportParameter reportParamDateTo = new ReportParameter("toDate", TextBoxDateTo.Text);
                reportParameters.Add(reportParamDateTo);

                ServerReportParameters += Environment.NewLine + " toDate: " + TextBoxDateTo.Text;
            }
        }
        private void SetDateFrom()
        {
            if (DateFrom && TextBoxDateFrom.Text != "")
            {
                ReportParameter reportParamDateFrom = new ReportParameter("fromDate", TextBoxDateFrom.Text);
                reportParameters.Add(reportParamDateFrom);

                ServerReportParameters += Environment.NewLine + " fromDate: " + TextBoxDateFrom.Text;
            }
        }
        private void SetReferralId()
        {
            if (ShowReferralId && TextBoxReferralId.Text != "")
            {
                ReportParameter reportParamReferralId = new ReportParameter("referralId", TextBoxReferralId.Text);
                reportParameters.Add(reportParamReferralId);

                ServerReportParameters += Environment.NewLine + " referralId: " + TextBoxReferralId.Text;
            }
        }

        private void SetYears()
        {
            if (YearsSelection)
            {
                var selectedIndices = ListBoxYearSelection.GetSelectedIndices();
                var selectedYears = new List<string>();

                for (int i = 0; i < selectedIndices.Count(); i++)
                {
                    selectedYears.Add(ListBoxYearSelection.Items[selectedIndices[i]].Text);
                }

                ReportParameter reportParamYears = new ReportParameter("RptYrSel", selectedYears.ToArray());
                reportParameters.Add(reportParamYears);

                ServerReportParameters += Environment.NewLine + " Years Selected: " + String.Join(", ", selectedYears.ToArray());
            }

            //Test years: 
            //ReportParameter reportParamYears = new ReportParameter("RptYrSel", "2010");
            //_reportParameters.Add(reportParamYears);
        }

        private void SetVisns()
        {
            if (VisnsSelection)
            {
                var selectedVisnsIndices = ListBoxVisns.GetSelectedIndices();
                var selectedVisns = new List<string>();

                foreach (var index in selectedVisnsIndices)
                {
                    if (ListBoxVisns.Items[index].Text.Length == 6)
                    {
                        selectedVisns.Add(ListBoxVisns.Items[index].Text.Substring(0, 1)
                                          + "0"
                                          + ListBoxVisns.Items[index].Text.Substring(5, ListBoxVisns.Items[index].Text.Length - 5));
                    }
                    else
                    {
                        selectedVisns.Add(ListBoxVisns.Items[index].Text.Substring(0, 1)
                                          + ListBoxVisns.Items[index].Text.Substring(5, ListBoxVisns.Items[index].Text.Length - 5));
                    }
                }

                ReportParameter reportParamVisns = new ReportParameter("VisnID", selectedVisns.ToArray());
                reportParameters.Add(reportParamVisns);

                //Test visns: 
                //ReportParameter reportParamVisns = new ReportParameter("VisnID", "V23");
                //_reportParameters.Add(reportParamVisns);

                ServerReportParameters += Environment.NewLine + " VISN's Selected: " + String.Join(", ", selectedVisns.ToArray());
            }
        }

        private void SetYearsDefinition()
        {
            if (YearsDefinition)
            {
                ReportParameter reportParamYearDefinition =
                    new ReportParameter("RptYrDef", DropDownListYearDefinition.SelectedItem.Text);
                reportParameters.Add(reportParamYearDefinition);

                //Test year definition: 
                //ReportParameter reportParamYearDefinition = new ReportParameter("RptYrDef", "Fiscal Year");
                //_reportParameters.Add(reportParamYearDefinition);

                ServerReportParameters += Environment.NewLine + " Year Type: " + DropDownListYearDefinition.SelectedItem.Text;
            }
        }

        private void SetUsernameFilter()
        {
            if (UserNameFilter)
            {
                //username
                ReportParameter reportParamUsername = new ReportParameter("UsernameFilter", TextBoxUserName.Text);
                reportParameters.Add(reportParamUsername);

                //Test user: 
                //ReportParameter reportParamUsername = new ReportParameter("Username", "aboros99");
                //_reportParameters.Add(reportParamUsername);

                ServerReportParameters += Environment.NewLine + " Username Filter: " + TextBoxUserName.Text;
            }
        }

        private void SetUsername()
        {
            //user
            ReportParameter reportParamUsername = new ReportParameter("Username", HttpContext.Current.User.Identity.Name);
            reportParameters.Add(reportParamUsername);

            //Test user: 
            //ReportParameter reportParamUsername = new ReportParameter("Username", "aboros99");
            //_reportParameters.Add(reportParamUsername);
        }

        private void GetYearsListBox()
        {
            for (int i = DateTime.Now.Year + 1; i >= 2000; i--)
            {
                ListBoxYearSelection.Items.Add(new ListItem(i.ToString()));
            }

            for (int i = 0; i < ListBoxYearSelection.Items.Count; i++)
            {
                ListBoxYearSelection.Items[i].Selected = true;
            }
        }

        private void GetVisnsListBox()
        {
            ListBoxVisns.DataSource = ObjectDataSourceRegistryVISNs;
            ListBoxVisns.DataBind();

            for (int i = 0; i < ListBoxVisns.Items.Count; i++)
            {
                ListBoxVisns.Items[i].Selected = true;
            }
        }

        protected void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}
